# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 5
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR5_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Initial move: Cooperate
    if current_round == 1:
        return "C"
    
    # Check for deterministic opponent strategies
    always_cooperate = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_defect = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    
    if always_defect:
        return "D"
    if always_cooperate and current_round >= 2:
        return "D"
    
    # Late-game adjustment: defect in last 2 rounds
    if current_round >= total_rounds - 1:
        return "D"
    
    # If opponent is non-deterministic, use TFT with forgiveness
    if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
        return "C"
    
    # If opponent defects more than twice in first 5 rounds, switch to D
    if current_round <= 5 and opp_history.count("D") > 2:
        return "D"
    
    # Default: mirror opponent's last move
    return opp_history[-1] if opp_history else "C"